<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

class Elementor_How_it_works_Widget extends \Elementor\Widget_Base {

	public function get_name() {
		return 'services_widget';
	}

	public function get_title() {
		return esc_html__( 'Steps List', 'elementor-pro' );
	}

	public function get_icon() {
		return 'eicon-code';
	}

	public function get_categories() {
		return [ 'hd-custom-widgets' ];
	}

	public function get_keywords() {
		return [ 'Steps List', 'Steps', 'List' ];
	}

	public function get_custom_help_url() {
		return 'https://developers.elementor.com/docs/widgets/';
	}
	
	
	protected function register_controls(): void {

		$this->start_controls_section(
			'section_step_content',
			[
				'label' => esc_html__( 'Content', 'elementor-pro' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);


		$this->add_control(
			'list',
			[
				'label' => esc_html__( 'List', 'elementor-pro' ),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'fields' => [
					[
						'name' => 'heading',
						'label' => esc_html__( 'Heading', 'elementor-pro' ),
						'type' => \Elementor\Controls_Manager::TEXT,
						'placeholder' => esc_html__( 'Heading', 'elementor-pro' ),
						'default' => esc_html__( 'Heading', 'elementor-pro' ),
					],
					[
						'name' => 'text',
						'label' => esc_html__( 'Text', 'elementor-pro' ),
						'type' => \Elementor\Controls_Manager::WYSIWYG,
						'placeholder' => esc_html__( 'List Item', 'elementor-pro' ),
						'default' => esc_html__( 'List Item', 'elementor-pro' ),
					],
					[
						'name' => 'image',
						'label' => esc_html__( 'Choose Image', 'elementor-pro' ),
						'type' => \Elementor\Controls_Manager::MEDIA,
						'default' => [
        					'url' => \Elementor\Utils::get_placeholder_image_src(),
        				],
					],
				],
				'default' => [
					[
						'text' => esc_html__( 'List Item', 'elementor-pro' ),
						'image' => \Elementor\Utils::get_placeholder_image_src(),
					],
				],
				'title_field' => '{{{ heading }}}',
			]
		);

		$this->end_controls_section();
		
		$this->start_controls_section(
			'section_style',
			[
				'label' => esc_html__( 'Style', 'elementor-pro' ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);
		
		// Heading group control
		$this->add_control(
			'heading_color',
			[
				'label' => esc_html__( 'Heading Color', 'elementor-pro' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'default' => '#000',
				'selectors' => [
					'{{WRAPPER}} h2' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'heading_typography',
				'selector' => '{{WRAPPER}} h2',
			]
		);
        
        // content group control
		$this->add_control(
			'content_color',
			[
				'label' => esc_html__( 'Content Color', 'elementor-pro' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'default' => '#000',
				'selectors' => [
					'{{WRAPPER}} .step-content' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'content_typography',
				'selector' => '{{WRAPPER}} .step-content',
			]
		);

		$this->end_controls_section();

	}

	protected function render(): void {
		
		$settings = $this->get_settings_for_display();
		$this->add_inline_editing_attributes( 'heading', 'none' );
		//$this->add_inline_editing_attributes( 'description', 'basic' );
		$this->add_inline_editing_attributes( 'content', 'advanced' );

		if ( ! $settings['list'] ) {
			return;
		}
		?>
		<style>
			
			.step-container .step-content {
/* 				font-family: "Akzidenz Grotest Light Font", Sans-serif !important;
				font-weight: 300 !important;
				color: #2C2C2C !important;
				font-size: 18px !important; */
			}
			
            .tabs {display: flex; justify-content: space-between; position:relative;}
			.tabs:after {
				content: '';
				position: absolute;
				height: 2px;
				background-color: #f9943b;
				width: 100%;
				top: 50%;
				transform: translateY(-50%);
			}
        
            .tab-button {
				color:#1C2740;
              	cursor: pointer;
              	background-color: #fff;
              	font-size: 28px;
				border: 2px solid #F9943B;
				border-radius: 100%;
				width: 150px;
    			height: 150px;
				font-family: "Abril Fatface", Sans-serif;
				z-index:9;
            }
			.tab-button.active {background-color: #F9943B; color: #fff;}
        	
            .tab-content {display: none; position: relative;}
            .tab-content.active {
              display: block; margin-top: 130px;
            }
			.tab-content .step-image {
				max-width: 65%;
				position: relative;
				display: flex;
				width: 100%;
				height: 0;
				padding-top: 650px;
			}
			.tab-content .step-image img{
				z-index:1;
				position: absolute;
				width: 100%;
				height: 100%;
				object-fit: cover;
				object-position: center;
				top: 0;
				left: 0;
			}
			.tab-content .step-image:before {
				content: '';
				background-color: #1C2740;
				position: absolute;
				top: -60px;
				left: 54%;
				width: 100%;
				height: 100%;
				opacity: 0.8;
			}
			.tab-content .step-content {
				width: 50%;
				background-color: rgba(255,255,255,0.9);
				padding: 80px;
				position: absolute;
				top: calc(50% - 40px);
				transform: translateY(-50%);
				z-index: 1;
				right: 90px;
			}
			.tab-content .step-content h2 {
				margin-top: 0;
			}
			.tab-content .step-content ul {
				list-style-type: none;
				padding-left: 20px;
			}
			.tab-content .step-content ul li {
				position: relative;margin-bottom:10px;
			}
			.tab-content .step-content ul li:before {
				content: '';
				background-image: url("<?php echo get_stylesheet_directory_uri(); ?>/elementor/widgets/icons/arrow-right.svg");
				width: 12px;
				height: 10px;
				display: inline-block;
				left: -12px;
				position: relative;
			}
			
			@media(max-width:1500px){
				.tab-button{width: 130px; height: 130px; font-size:22px;}
				.tab-content .step-image{padding-top:500px;}
				.tab-content .step-content{width:60%; padding: 40px; right: 70px;}
/* 				.tab-content .step-content h2 {font-size: 40px !important;} */
			}
			@media(max-width:1500px){
				
			}
        </style>
        
        <script>
            jQuery(document).ready(function($) {
              $('.tab-button').click(function() {
                var tabId = $(this).data('tab');
        
                // Remove active class
                $('.tab-button').removeClass('active');
                $('.tab-content').removeClass('active');
        
                // Add active class to current
                $(this).addClass('active');
                $('#' + tabId).addClass('active');
              });
            });
        </script>
        
        <?php if($settings['list']){ ?>
    		<div class="step-container">
    		    
    		    <div class="tabs">
    		        <?php foreach ( $settings['list'] as $index => $item ) : ?>
                        <button class="tab-button<?php echo ($index==0) ? ' active' : ''; ?>" data-tab="tab<?php echo $index; ?>">STEP <?php echo $index + 1; ?></button>
                    <?php endforeach; ?>
                </div>
                
                <?php
                foreach ( $settings['list'] as $index => $item ) : ?>
                    <div id="tab<?php echo $index; ?>" class="tab-content<?php echo ($index==0) ? ' active' : ''; ?>">
                        <div class="step-image">
                            <?php echo '<img src="' . esc_url( $item['image']['url'] ) . '" alt="">'; ?>
                        </div>
                        <div class="step-content">
                            <h2 <?php $this->print_render_attribute_string( 'heading' ); ?>><?php echo $item['heading']; ?></h2>
                            <div <?php $this->print_render_attribute_string( 'content' ); ?>><?php echo $item['text']; ?></div>
            			</div>
                    </div>
                <?php endforeach; ?>
           
    		</div>
		<?php
        }
	}

    /*
	protected function content_template(): void {
		?>
		<#
		if ( ! settings.list.length ) {
			return;
		}
		#>
		<div class="step-container">
    		    
		    <div class="tabs">
		        <# _.each( settings.list, function( item, index ) { #>
                    <button class="tab-button <# if ( index == 0 ) { {{{active}}} } #>" data-tab="tab{{{index}}}">STEP {{{ index + 1 }}}</button>
                <# } ); #>
            </div>
            
            <# _.each( settings.list, function( item, index ) { #>
            
                <div id="tab{{{index}}}" class="tab-content <# if ( index == 0 ) { {{{active}}} } #>">
                    <div class="step-image">
                        <img src="{{{ settings.image.url }}}">
                    </div>
                    <div class="step-content">
        			    {{{ item.text }}}
        			</div>
                </div>
                
            <# } ); #>
       
		</div>
		
		<?php
	}
	*/

    /*
	protected function register_controls() {

		// Content Tab Start
		$this->start_controls_section(
			'how_it_works_section_options',
			[
				'label' => esc_html__( 'Option Settings', 'elementor-pro' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
				//'type' => \Elementor\Controls_Manager::SECTION,
			]
		);
	
		$this->add_control(
			'steps-list',
			[
				'label' => esc_html__( 'Steps List', 'elementor-pro' ),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'fields' => [
					[
						'name' => 'step-heading',
						'label' => esc_html__( 'Heading', 'elementor-pro' ),
						'type' => \Elementor\Controls_Manager::TEXT,
						'placeholder' => esc_html__( 'List Heading', 'elementor-pro' ),
						'default' => esc_html__( 'List Heading', 'elementor-pro' ),
					],
					[
						'name' => 'step-content',
						'label' => esc_html__( 'Content', 'elementor-pro' ),
						'type' => \Elementor\Controls_Manager::WYSIWYG,
						'placeholder' => esc_html__( 'Content', 'elementor-pro' ),
					],
				],
				'default' => [
					[
						'step-heading' => esc_html__( 'List Heading', 'elementor-pro' ),
						'step-content' => esc_html__( 'Content', 'elementor-pro' ),
					],
					[
						'step-heading' => esc_html__( 'List Heading', 'elementor-pro' ),
						'step-content' => esc_html__( 'Content', 'elementor-pro' ),
					],
				],
				'title_field' => '{{{ step-heading }}}',
			]
		);
		
		
		$this->end_controls_section();

	}

	protected function render() {
		$settings = $this->get_settings_for_display();
		//if ( empty( $settings['title'] ) ) {
		//		return;
		//}
		$show_dots = ( in_array( $settings['navigation'], [ 'dots', 'both' ] ) );
		$show_arrows = ( in_array( $settings['navigation'], [ 'arrows', 'both' ] ) );
		//$number_of_posts = $settings['number_of_posts'];
		$autoplay = $settings['autoplay'];
		$autoplay_speed = $settings['autoplay_speed'];
		$infinite = $settings['infinite'];
		?>

		<style>
		</style>


 		<script type="text/javascript">
			jQuery(document).ready(function() {
				
			});
		</script>
		
		<!-- Slider main container -->
		<?php
		
	}
	*/
	

}