<?php 
// Enqueue Styles and Scripts
function ibg_enqueue_scripts() {
    wp_enqueue_style('ibg-style', get_stylesheet_uri());
    
    wp_enqueue_script('ibg-main', get_template_directory_uri() . '/assets/js/main.js', array('jquery'), '1.0', true);
}
add_action('wp_enqueue_scripts', 'ibg_enqueue_scripts');

// Theme Support Features
function ibg_theme_setup() {
    add_theme_support('title-tag');
    add_theme_support('post-thumbnails');
    add_theme_support('custom-logo');
    add_theme_support('automatic-feed-links');
    add_theme_support('html5', array('search-form', 'comment-form', 'comment-list', 'gallery', 'caption'));
    //add_theme_support('woocommerce');
    
    register_nav_menus(array(
        'primary' => __('Primary Menu', 'impactedbusinessgroup')
    ));
}
add_action('after_setup_theme', 'ibg_theme_setup');

// Register Widget Areas
function ibg_widgets_init() {
    register_sidebar(array(
        'name'          => __('Sidebar', 'impactedbusinessgroup'),
        'id'            => 'sidebar-1',
        'description'   => __('Add widgets here.', 'impactedbusinessgroup'),
        'before_widget' => '<div class="widget">',
        'after_widget'  => '</div>',
        'before_title'  => '<h2 class="widget-title">',
        'after_title'   => '</h2>',
    ));
}
add_action('widgets_init', 'ibg_widgets_init');


/* Elementor widget */
get_template_part( '/elementor/functions' );


function cc_mime_types($mimes) 
{
    $mimes['svg'] = 'image/svg+xml';
    $mimes['webp'] = 'image/webp';
    return $mimes;
}
add_filter('upload_mimes', 'cc_mime_types');


function cptui_register_my_cpts() {

	/**
	 * Post Type: Case Studies.
	 */

	$labels = [
		"name" => esc_html__( "Case Studies", "impactedbusinessgroup" ),
		"singular_name" => esc_html__( "Case Study", "impactedbusinessgroup" ),
	];

	$args = [
		"label" => esc_html__( "Case Studies", "impactedbusinessgroup" ),
		"labels" => $labels,
		"description" => "",
		"public" => true,
		"publicly_queryable" => true,
		"show_ui" => true,
		"show_in_rest" => true,
		"rest_base" => "",
		"rest_controller_class" => "WP_REST_Posts_Controller",
		"rest_namespace" => "wp/v2",
		"has_archive" => false,
		"show_in_menu" => true,
		"show_in_nav_menus" => true,
		"delete_with_user" => false,
		"exclude_from_search" => false,
		"capability_type" => "post",
		"map_meta_cap" => true,
		"hierarchical" => true,
		"can_export" => false,
		"rewrite" => [ "slug" => "casestudies", "with_front" => true ],
		"query_var" => true,
		"supports" => [ "title", "editor", "thumbnail", "page-attributes" ],
		"show_in_graphql" => false,
	];

	register_post_type( "casestudies", $args );
}

add_action( 'init', 'cptui_register_my_cpts' );
